local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		function Sound(str)
        local songName = GAMESTATE:GetCurrentSong():GetSongDir();
        SOUND:PlayOnce(songName..'mods/'..str..'.ogg');
    end
		
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local flashMod = '*10 drunk,*10 15% stealth,*10 25% dizzy'
		local stealthHigh = '*10 55% stealth'

		local pianoPart = '*4.3 150% distant,*2 45% bumpy'

		local rand = '*99 invert,*99 75% stealth'
		local randOff = '*99 no invert,*99 no stealth'

		mods = {
			{0, '2.5x,blind'},
			{8, '*10 drunk'},
			{16, '*99 -100% drunk'},
			{24, '*99 drunk'},
			{32, '*99 625% dizzy'},
			{40, '*99 no drunk,*99 no dizzy'},
			{48, flashMod},
			{80, stealthHigh},
			{80.25, '*0.1 15% stealth'},
			{112, stealthHigh},
			{112.25, '*0.1 15% stealth'},
			{126.5, '*24 -100% drunk'},
			{127, '*24 drunk'},
			{127.333, '*24 -100% drunk'},
			{127.667, '*24 drunk'},
			{128, '*24 -100% drunk'},
			{136, '*3 no drunk,no dizzy,no stealth'},
			{144, pianoPart, '*2 30% centered'},
			{176, '*99 55% stealth'},
			{176.25, 'no stealth'},
			{208, '*2 dark'},
			{209.5, '*5 no bumpy,*5 no centered'},
			{211, '*99 reverse,*99 overhead'},
			{217, '*99 split'},
			{225, '*99 no reverse,*99 no split'},
			{240, '*15 beat,*99 no split'},
			{268, '*5 no beat,*3 no dark'},
			{304, '*4 150% distant,*4 125% drunk,*4 55% bumpy'},
			{336, '*99 55% stealth,*10 dizzy'},
			{336.25, '*3 no stealth'},
			{368, '*99 overhead,*99 no drunk,*99 no dizzy,*99 no bumpy'}
		}

dezz={{10,11},{18,19},{26,27}}

for i,v in pairs(dezz) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*99 2000% dizzy'})
		table.insert(mods, {beat + 1, '*1000 no dizzy'})
    end
end
		
for beat=0,5.625, 1 do
	table.insert(mods, {beat, '*99 -150% tiny'})
	table.insert(mods, {beat + 0.125, '*14 no tiny'})
	table.insert(mods, {beat + 0.25, '*99 -150% tiny'})
	table.insert(mods, {beat + 0.375, '*14 no tiny'})
	table.insert(mods, {beat + 0.5, '*99 -150% tiny'})
	table.insert(mods, {beat + 0.625, '*14 no tiny'})
	table.insert(mods, {beat + 0.75, '*99 -150% tiny'})
	table.insert(mods, {beat + 0.875, '*14 no tiny'})
end
		
for beat=54,55, 1 do
	table.insert(mods, {beat, '*16 150% distant'})
	table.insert(mods, {beat + 0.333, '*24 150% hallway'})
	table.insert(mods, {beat + 0.667, '*16 150% distant'})
	table.insert(mods, {beat + 1, '*24 overhead'})
end

for beat=86,87.667, 1 do
	table.insert(mods, {beat, '*24 -100% drunk'})
	table.insert(mods, {beat + 0.333, '*24 drunk'})
	table.insert(mods, {beat + 0.667, '*24 -100% drunk'})
	table.insert(mods, {beat + 1, '*24 drunk'})
end

randomizeX2={{143,143.5},{160,163},{192,195},{239,239.5},{320,323},{352,355}}

for i,v in pairs(randomizeX2) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, rand})
		table.insert(mods, {beat + 0.167, randOff})
		table.insert(mods, {beat + 0.333, rand})
		table.insert(mods, {beat + 0.5, randOff})
		table.insert(mods, {beat + 0.667, rand})
		table.insert(mods, {beat + 0.833, randOff})
    end
end

randomizeX3={{236,236.375},{237,237.375},{238,238.375}}

for i,v in pairs(randomizeX3) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, rand})
		table.insert(mods, {beat + 0.125, randOff})
		table.insert(mods, {beat + 0.25, rand})
		table.insert(mods, {beat + 0.375, randOff})
    end
end

randomize={{272,272.5},{273.5,274},{275,276.5},{277.5,278},{279,280.5},{281.5,282},{283,284.5},{285.5,286},{287,288.5},{289.5,290},{291,292.5},{293.5,294},{295,296.5},{297.5,298},{299,300.5},{301.5,302},{303,303.5}}

for i,v in pairs(randomize) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, rand})
		table.insert(mods, {beat + 0.25, randOff})
		table.insert(mods, {beat + 0.5, rand})
		table.insert(mods, {beat + 0.75, randOff})
    end
end


		local vibbScr = function()
			screen:vibrate()
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
			screen:stopeffect()
		end

		local centerPlyrs = function()
			for i=1, #players do
				players[i]
					:x(SCREEN_CENTER_X)
			end
		end

		local byeHi = function()
			for i=1, #players do
				players[i]
					:linear(0.5)
					:skewx(100)
					:linear(0.75)
					:skewx(0)
			end
		end

		local yeah = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:skewx(1)
			end
		end
		
		local yeah2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.1)
					:skewx(-1)
			end
		end

		local resetPlyrs = function()
			for i=1, #players do
				players[i]
					:skewx(0)
			end
		end

		actorCmds = {
			{6, yeah},
			{6.5, yeah2},
			{7, yeah},
			{7.5, yeah2},
			{7.75, yeah},
			{8, resetPlyrs},
			{40, byeHi},
			{42, centerPlyrs},
			{207.5, function() Sound('Hit') end},
			{368, vibbScr},
			{368, function() Sound('Kill') end},
			{370, stopEffect}
		}

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,
	
	Def.Sprite{
    InitCommand= cmd(hibernate,5.4;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,999),
    OnCommand= cmd(sleep,0.05;linear,0.75;diffusealpha,0),
    Texture= "white.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,5.4;x,SCREEN_CENTER_X-100;y,SCREEN_CENTER_Y-200;zoom,0.5),
    OnCommand= cmd(sleep,122;linear,2;diffusealpha,0),
    Texture= "lifebar.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,5.4;x,SCREEN_CENTER_X-255;y,SCREEN_CENTER_Y-200;zoom,0.5),
    OnCommand= cmd(sleep,122;linear,2;diffusealpha,0),
    Texture= "face.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,5.4;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),
    OnCommand= cmd(sleep,11;diffusealpha,0),
    Texture= "idle 3x1.png",
  },

	Def.Sprite{
    InitCommand= cmd(hibernate,16.4;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y),
    OnCommand= cmd(sleep,2.8;diffusealpha,0),
    Texture= "cast.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;hibernate,16.4;linear,1;rotationz,360*10),
    OnCommand= cmd(sleep,1.8;diffusealpha,0),
    Texture= "casting.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,5.4;x,SCREEN_CENTER_X-77;y,SCREEN_CENTER_Y-200;zoom,0.3;zoomx,0.79),
    OnCommand= cmd(sleep,67.4;faderight,1;sleep,54;faderight,50),
    Texture= "health.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(diffusealpha,0;hibernate,51.2;x,SCREEN_CENTER_X+200;y,SCREEN_CENTER_Y;linear,1;diffusealpha,1),
    OnCommand= cmd(sleep,20.8;diffusealpha,0),
    Texture= "idle 3x1.png",
  },
  
  	Def.Sprite{
    InitCommand= cmd(hibernate,72.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,999;diffuse,1,0,0,1,blend,'add'),
    OnCommand= cmd(sleep,0.25;linear,0.1;diffusealpha,0),
    Texture= "white.png",
  },
  
  	Def.Sprite{
    InitCommand= cmd(hibernate,72.8;x,SCREEN_CENTER_X+200;y,SCREEN_CENTER_Y;linear,1;addx,50),
    OnCommand= cmd(sleep,1.4;diffusealpha,0),
    Texture= "hurt.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(diffusealpha,0;hibernate,93.3;x,SCREEN_CENTER_X+200;y,SCREEN_CENTER_Y;linear,1;diffusealpha,1),
    OnCommand= cmd(sleep,11.8;diffusealpha,0),
    Texture= "idle 3x1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,126.8;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,999),
    OnCommand= cmd(sleep,0.25;linear,0.5;diffusealpha,0),
    Texture= "white.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,126.8;x,SCREEN_CENTER_X+200;y,SCREEN_CENTER_Y;linear,1;addx,100;rotationy,360),
    OnCommand= cmd(sleep,1.5;linear,1.5;diffusealpha,0),
    Texture= "hurt.png",
  },

	Def.Sprite{
    InitCommand= cmd(hibernate,19;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,999),
    OnCommand= cmd(sleep,0.05;linear,0.75;diffusealpha,0),
    Texture= "white.png",
  },

	Def.Sprite{
    InitCommand= cmd(hibernate,19;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomtowidth,SCREEN_WIDTH;zoomtoheight,SCREEN_HEIGHT;animate,1),
    OnCommand= cmd(sleep,30;linear,2;diffusealpha,0),
    Texture= "Snow 3x1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,105.3;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,999),
    OnCommand= cmd(sleep,0.05;linear,0.75;diffusealpha,0),
    Texture= "white.png",
  },

	Def.Sprite{
    InitCommand= cmd(hibernate,105.3;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomtowidth,SCREEN_WIDTH;zoomtoheight,SCREEN_HEIGHT;animate,1),
    OnCommand= cmd(sleep,24;linear,2;diffusealpha,0),
    Texture= "Snow 3x1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,105.3;x,SCREEN_CENTER_X+200;y,SCREEN_CENTER_Y;bob,1;effectperiod,4;effectclock,'music'),
    OnCommand= cmd(sleep,21.5;diffusealpha,0),
    Texture= "cast.png",
  },

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
	
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_1)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.25)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_2)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.75)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
}
